/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.node;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.ICoverable;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.IStorage;
import com.refinedmods.refinedstorage.api.storage.IStorageProvider;
import com.refinedmods.refinedstorage.api.storage.StorageType;
import com.refinedmods.refinedstorage.api.storage.cache.InvalidateCause;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorageProvider;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.IStorageScreen;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.FluidStorageCache;
import com.refinedmods.refinedstorage.apiimpl.storage.cache.ItemStorageCache;
import com.refinedmods.refinedstorage.blockentity.ExternalStorageBlockEntity;
import com.refinedmods.refinedstorage.blockentity.config.IAccessType;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IPrioritizable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.util.AccessTypeUtils;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalStorageNetworkNode
extends NetworkNode
implements IStorageProvider,
IStorageScreen,
IComparable,
IWhitelistBlacklist,
IPrioritizable,
IType,
IAccessType,
IExternalStorageContext,
ICoverable {
    public static final ResourceLocation ID = new ResourceLocation("refinedstorage", "external_storage");
    private static final Logger LOGGER = LogManager.getLogger(ExternalStorageNetworkNode.class);
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private final BaseItemHandler itemFilters = new BaseItemHandler(9).addListener(new NetworkNodeInventoryListener(this));
    private final FluidInventory fluidFilters = new FluidInventory(9).addListener(new NetworkNodeFluidInventoryListener(this));
    private final List<IExternalStorage<ItemStack>> itemStorages = new CopyOnWriteArrayList<IExternalStorage<ItemStack>>();
    private final List<IExternalStorage<FluidStack>> fluidStorages = new CopyOnWriteArrayList<IExternalStorage<FluidStack>>();
    private final CoverManager coverManager;
    private int priority = 0;
    private int compare = 1;
    private int mode = 1;
    private int type = 0;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int networkTicks;

    public ExternalStorageNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
        this.coverManager = new CoverManager(this);
    }

    @Override
    public int getEnergyUsage() {
        return RS.SERVER_CONFIG.getExternalStorage().getUsage();
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
        super.onConnectedStateChange(network, state, cause);
        LOGGER.debug("Connectivity state of external storage at {} changed to {} due to {}", (Object)this.pos, (Object)state, (Object)cause);
        this.updateStorage(network, InvalidateCause.CONNECTED_STATE_CHANGED);
    }

    @Override
    public void update() {
        super.update();
        if (this.canUpdate() && this.level.m_46749_(this.pos)) {
            if (this.networkTicks++ == 0) {
                this.updateStorage(this.network, InvalidateCause.INITIAL_TICK_INVALIDATION);
                return;
            }
            for (IExternalStorage<ItemStack> iExternalStorage : this.itemStorages) {
                iExternalStorage.update(this.network);
            }
            for (IExternalStorage<ItemStack> iExternalStorage : this.fluidStorages) {
                iExternalStorage.update(this.network);
            }
        }
    }

    @Override
    public void onDirectionChanged(Direction direction) {
        super.onDirectionChanged(direction);
        if (this.network != null) {
            this.updateStorage(this.network, InvalidateCause.DEVICE_CONFIGURATION_CHANGED);
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilters, 0, tag);
        tag.m_128365_(NBT_FLUID_FILTERS, (Tag)this.fluidFilters.writeToNbt());
        tag.m_128405_(NBT_PRIORITY, this.priority);
        tag.m_128405_(NBT_COMPARE, this.compare);
        tag.m_128405_(NBT_MODE, this.mode);
        tag.m_128405_(NBT_TYPE, this.type);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        StackUtils.readItems(this.itemFilters, 0, tag);
        if (tag.m_128441_(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.m_128469_(NBT_FLUID_FILTERS));
        }
        if (tag.m_128441_(NBT_PRIORITY)) {
            this.priority = tag.m_128451_(NBT_PRIORITY);
        }
        if (tag.m_128441_(NBT_COMPARE)) {
            this.compare = tag.m_128451_(NBT_COMPARE);
        }
        if (tag.m_128441_(NBT_MODE)) {
            this.mode = tag.m_128451_(NBT_MODE);
        }
        if (tag.m_128441_(NBT_TYPE)) {
            this.type = tag.m_128451_(NBT_TYPE);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    @Override
    public int getWhitelistBlacklistMode() {
        return this.mode;
    }

    @Override
    public void setWhitelistBlacklistMode(int mode) {
        this.mode = mode;
        this.markDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markDirty();
        if (this.network != null) {
            this.network.getItemStorageCache().sort();
            this.network.getFluidStorageCache().sort();
        }
    }

    public void updateStorage(INetwork network, InvalidateCause cause) {
        this.itemStorages.clear();
        this.fluidStorages.clear();
        BlockEntity facing = this.getFacingBlockEntity();
        if (facing != null) {
            if (this.type == 0) {
                for (IExternalStorageProvider provider : API.instance().getExternalStorageProviders(StorageType.ITEM)) {
                    if (!provider.canProvide(facing, this.getDirection())) continue;
                    this.itemStorages.add(provider.provide(this, this.getFacingBlockEntity(), this.getDirection()));
                    break;
                }
            } else if (this.type == 1) {
                for (IExternalStorageProvider provider : API.instance().getExternalStorageProviders(StorageType.FLUID)) {
                    if (!provider.canProvide(facing, this.getDirection())) continue;
                    this.fluidStorages.add(provider.provide(this, this.getFacingBlockEntity(), this.getDirection()));
                    break;
                }
            }
        }
        network.getNodeGraph().runActionWhenPossible(ItemStorageCache.INVALIDATE_ACTION.apply(cause));
        network.getNodeGraph().runActionWhenPossible(FluidStorageCache.INVALIDATE_ACTION.apply(cause));
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
        storages.addAll(this.itemStorages);
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        storages.addAll(this.fluidStorages);
    }

    @Override
    public Component getTitle() {
        return new TranslatableComponent("gui.refinedstorage:external_storage");
    }

    @Override
    public long getStored() {
        return ExternalStorageBlockEntity.STORED.getValue();
    }

    @Override
    public long getCapacity() {
        return ExternalStorageBlockEntity.CAPACITY.getValue();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType type) {
        this.accessType = type;
        if (this.network != null) {
            this.network.getItemStorageCache().invalidate(InvalidateCause.DEVICE_CONFIGURATION_CHANGED);
            this.network.getFluidStorageCache().invalidate(InvalidateCause.DEVICE_CONFIGURATION_CHANGED);
        }
        this.markDirty();
    }

    @Override
    public boolean acceptsItem(ItemStack stack) {
        return IWhitelistBlacklist.acceptsItem((IItemHandler)this.itemFilters, this.mode, this.compare, stack);
    }

    @Override
    public boolean acceptsFluid(FluidStack stack) {
        return IWhitelistBlacklist.acceptsFluid(this.fluidFilters, this.mode, this.compare, stack);
    }

    @Override
    public int getType() {
        return this.level.f_46443_ ? ExternalStorageBlockEntity.TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.markDirty();
        if (this.network != null) {
            this.updateStorage(this.network, InvalidateCause.DEVICE_CONFIGURATION_CHANGED);
        }
    }

    @Override
    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    @Override
    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }

    public List<IExternalStorage<ItemStack>> getItemStorages() {
        return this.itemStorages;
    }

    public List<IExternalStorage<FluidStack>> getFluidStorages() {
        return this.fluidStorages;
    }

    @Override
    public CoverManager getCoverManager() {
        return this.coverManager;
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        if (tag.m_128441_(CoverManager.NBT_COVER_MANAGER)) {
            this.coverManager.readFromNbt(tag.m_128469_(CoverManager.NBT_COVER_MANAGER));
        }
    }

    @Override
    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128365_(CoverManager.NBT_COVER_MANAGER, (Tag)this.coverManager.writeToNbt());
        return tag;
    }
}

